import java.util.Vector;
import java.util.Enumeration;
import misc.Debug;
import types.Transaction;


public class Timer extends Object {
    protected Computer m_Computer;
    protected Vector m_TimerList;
    public Timer(Computer computer) {
        m_Computer = computer;
        m_TimerList = new Vector(10);
    }
    public void newTimeStep() {
        for (Enumeration e = m_TimerList.elements();e.hasMoreElements();) {
            TimerEvent event = (TimerEvent) e.nextElement();
            if (event.decrease(1)) {
                Transaction t;
                m_Computer.timeOut(event.ID());
                if (m_Computer==Global.sender) {
                    t = new Transaction(event.ID(),-1);
                }
                else
                    t = new Transaction(-1,event.ID());
                Global.historyPanel.addTransaction(t);
           		Global.historyPanel.addWindow(Global.sender.protocol().sendWindow,
                                Global.receiver.protocol().receiveWindow);
                m_TimerList.removeElement(event);
            }
        }
    }

    public void insertTimer(int iID,int iTimeout) {
        removeTimer(iID);
        m_TimerList.addElement(new TimerEvent(iID,iTimeout));
    }
    public void removeTimer(int iID) {
        for (Enumeration e = m_TimerList.elements();e.hasMoreElements();) {
            TimerEvent event = (TimerEvent) e.nextElement();
            if (event.ID() == iID) {
                m_TimerList.removeElement(event);
            }
        }
    }
    public void removeAll() {
        m_TimerList.removeAllElements();
    }
}

class TimerEvent extends Object {
    int m_iID;
    int m_iTimeout;
    int m_iTime;
    public TimerEvent(int iID,int iTimeout) {
        m_iID = iID;
        m_iTimeout = iTimeout;
    }
    public boolean decrease(int iAnz) {
        m_iTimeout-=iAnz;
        if (m_iTimeout<0) {
            return(true);
        }
        return(false);
    }
    public int ID() {
        return(m_iID);
    }
}